Imports BOOL = System.UInt32

Imports SHORT16 = System.Int16

Imports USHORT16 = System.UInt16

Imports INT32 = System.Int32

Imports UINT32 = System.UInt32

Imports LONG32 = System.Int32

Imports ULONG32 = System.UInt32

Imports LONGLONG64 = System.Int64

Imports ULONGLONG64 = System.UInt64

Imports PVOID = System.UInt32

Imports HWND = System.UInt32

Imports HDC = System.UInt32

Imports COLORREF = System.UInt32

Imports DEVICE_HANDLE = System.UInt32

Public Class MyFileManagerControl

    Public m_pFileInfoList(0 To 3) As PVOID

    Public m_nStartSearchSystemTime As ULONGLONG64

    Public m_nStopSearchSystemTime As ULONGLONG64

    Public m_nLastSyncSystemTime As ULONGLONG64

    Public m_bIsExportRangeSelecting As Boolean

    Public m_nStartExportPoint As ULONG32

    Public m_nStopExportPoint As ULONG32

    Public Sub ExportFileToDisk()

        Dim s_system_time As DateTime = DateTime.FromFileTime(m_nStartSearchSystemTime)

        Dim s_start_search_system_time As DateTime = New DateTime(s_system_time.Year, s_system_time.Month, s_system_time.Day)

        Dim s_stop_search_system_time As DateTime = New DateTime(s_system_time.Year, s_system_time.Month, s_system_time.Day, 23, 59, 59, 999)

        Dim n_start_search_system_time As ULONGLONG64 = s_start_search_system_time.ToFileTimeUtc()

        Dim n_stop_search_system_time As ULONGLONG64 = s_stop_search_system_time.ToFileTimeUtc()

        Dim n_start_export_system_time As ULONGLONG64 = ((m_nStartExportPoint * (n_stop_search_system_time - n_start_search_system_time)) / Me.ClientRectangle.Width) + n_start_search_system_time

        Dim n_stop_export_system_time As ULONGLONG64 = ((m_nStopExportPoint * (n_stop_search_system_time - n_start_search_system_time)) / Me.ClientRectangle.Width) + n_start_search_system_time

        ' Dim s_system_time As DateTime = DateTime.Now

        Dim i As UINT32 = 0

        For i = 0 To 3

            Dim psz_src = "C:\SC5C0\CH" & (i + 1).ToString("D2") & "\"

            Dim psz_dst = "C:\BACKUP\" & s_system_time.Year.ToString("D4") & _
                                         s_system_time.Month.ToString("D2") & _
                                         s_system_time.Day.ToString("D2") & _
                                         s_system_time.Hour.ToString("D2") & _
                                         s_system_time.Minute.ToString("D2") & _
                                         s_system_time.Second.ToString("D2") & "\"

            System.IO.Directory.CreateDirectory(psz_dst)

            psz_dst = "C:\BACKUP\" & s_system_time.Year.ToString("D4") & _
                                     s_system_time.Month.ToString("D2") & _
                                     s_system_time.Day.ToString("D2") & _
                                     s_system_time.Hour.ToString("D2") & _
                                     s_system_time.Minute.ToString("D2") & _
                                     s_system_time.Second.ToString("D2") & "\CH" & (i + 1).ToString("D2") & "\"

            System.IO.Directory.CreateDirectory(psz_dst)

            Dim pDstFileRenderer As UINT32 = AMESDK.NET.EXPORTS.AMESDK_FILE_EXPORT_START(psz_src, psz_dst, n_start_export_system_time, n_stop_export_system_time)

            AMESDK.NET.EXPORTS.AMESDK_FILE_EXPORT_STOP(pDstFileRenderer)

        Next

    End Sub

    Public Sub EnumFileInfoFromDisk(ByVal bIsInitialize As Boolean)

        Dim n_start_search_system_time As ULONGLONG64 = ULONGLONG64.MinValue

        Dim n_stop_search_system_time As ULONGLONG64 = ULONGLONG64.MaxValue

        Dim s_system_time As DateTime = DateTime.Now

        Dim s_start_search_system_time As DateTime = New DateTime(s_system_time.Year, s_system_time.Month, s_system_time.Day)

        Dim s_stop_search_system_time As DateTime = New DateTime(s_system_time.Year, s_system_time.Month, s_system_time.Day, 23, 59, 59, 999)

        m_nStartSearchSystemTime = s_start_search_system_time.ToFileTime()

        m_nStopSearchSystemTime = s_stop_search_system_time.ToFileTime()

        m_nLastSyncSystemTime = s_system_time.ToFileTime()

        n_start_search_system_time = s_start_search_system_time.ToFileTimeUtc()

        n_stop_search_system_time = s_stop_search_system_time.ToFileTimeUtc()

        Dim i As ULONG32 = 0

        If bIsInitialize Then

            For i = 0 To 3

                Dim psz_search_directory = "C:\SC5C0\CH" & (i + 1).ToString("D2") & "\"

                m_pFileInfoList(i) = AMESDK.NET.EXPORTS.AMESDK_FILE_GET_FILE_INFO_LIST(psz_search_directory, n_start_search_system_time, n_stop_search_system_time) '18446744073709551615 = &HFFFFFFFFFFFFFFFF

            Next

        Else

            For i = 0 To 3

                Dim psz_search_directory = "C:\SC5C0\CH" & (i + 1).ToString("D2") & "\"

                AMESDK.NET.EXPORTS.AMESDK_FILE_UPDATE_FILE_INFO_LIST(m_pFileInfoList(i), psz_search_directory, n_start_search_system_time, n_stop_search_system_time) '18446744073709551615 = &HFFFFFFFFFFFFFFFF

            Next

        End If

        Me.Invalidate()

    End Sub

    Private Sub MyFileManagerControl_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed

        Dim i As ULONG32 = 0

        For i = 0 To 3

            AMESDK.NET.EXPORTS.AMESDK_FILE_FREE_FILE_INFO_LIST(m_pFileInfoList(i))

            m_pFileInfoList(i) = 0

        Next

    End Sub

    Private Sub MyFileManagerControl_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_bIsExportRangeSelecting = False

        m_nStartExportPoint = 0

        m_nStopExportPoint = 0

        Me.DoubleBuffered = True

        EnumFileInfoFromDisk(True)

    End Sub

    Private Sub MyFileManagerControl_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseDown

        m_nStartExportPoint = e.X

        m_nStopExportPoint = e.X

        m_bIsExportRangeSelecting = True

        Me.Invalidate()

    End Sub

    Private Sub MyFileManagerControl_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseUp

        m_nStopExportPoint = e.X

        m_bIsExportRangeSelecting = False

        Me.Invalidate()

    End Sub

    Private Sub MyFileManagerControl_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseMove

        If m_bIsExportRangeSelecting = True Then

            m_nStopExportPoint = e.X

            Me.Invalidate()

        End If

    End Sub

    Private Sub MyFileManagerControl_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Me.Paint

        ' DRAW EXPORT SELECTION BAR (LIGHT BLUE)
        '
        If (m_nStartExportPoint = m_nStopExportPoint) = False Then

            Dim po_exp As ULONG32 = m_nStartExportPoint

            Dim pe_exp As ULONG32 = m_nStopExportPoint

            If m_nStartExportPoint > m_nStopExportPoint Then po_exp = m_nStopExportPoint

            If m_nStartExportPoint > m_nStopExportPoint Then pe_exp = m_nStartExportPoint

            e.Graphics.FillRectangle(Brushes.Gold, New Rectangle(po_exp, 0, pe_exp - po_exp, Me.ClientRectangle.Height))

        End If

        ' DRAW CURRENT RECORD FILE BAR (GREEN)
        '
        Dim n_start_search_system_times As ULONGLONG64 = m_nStartSearchSystemTime

        Dim n_stop_search_system_times As ULONGLONG64 = m_nStopSearchSystemTime

        Dim n_start_sync_system_time As ULONGLONG64 = m_nLastSyncSystemTime

        Dim n_stop_sync_system_time As ULONGLONG64 = DateTime.Now.ToFileTime()

        Dim po_sync As ULONGLONG64 = ((n_start_sync_system_time - n_start_search_system_times) * Me.ClientRectangle.Width) / (n_stop_search_system_times - n_start_search_system_times)

        Dim pe_sync As ULONGLONG64 = ((n_stop_sync_system_time - n_start_search_system_times) * Me.ClientRectangle.Width) / (n_stop_search_system_times - n_start_search_system_times) + (1)

        e.Graphics.FillRectangle(Brushes.Green, New Rectangle(po_sync, 0, pe_sync - po_sync, Me.ClientRectangle.Height - 2))

        ' DRAW OLD RECORD FILES BAR (BLUE) + PLAYBACK LINE (RED)
        '
        Dim i As ULONG32

        Dim j As ULONG32

        For i = 0 To 3

            Dim counts As ULONG32 = 0

            AMESDK.NET.EXPORTS.AMESDK_FILE_GET_FILE_INFO_LIST_SIZE(m_pFileInfoList(i), counts)

            If counts > 0 Then

                For j = 0 To (counts - 1)

                    Dim s_file_info As AMESDK.NET.EXPORTS.AMESDK_FILE_INFO = New AMESDK.NET.EXPORTS.AMESDK_FILE_INFO

                    AMESDK.NET.EXPORTS.AMESDK_FILE_GET_FILE_INFO_LIST_ELEMENT(m_pFileInfoList(i), j, s_file_info)

                    Dim s_start_record_system_time As DateTime = DateTime.FromFileTimeUtc(s_file_info.m_nFileStartTime)

                    Dim s_stop_record_system_time As DateTime = DateTime.FromFileTimeUtc(s_file_info.m_nFileStopTime)

                    s_start_record_system_time = New DateTime(s_start_record_system_time.Year, s_start_record_system_time.Month, s_start_record_system_time.Day, s_start_record_system_time.Hour, s_start_record_system_time.Minute, s_start_record_system_time.Second, s_start_record_system_time.Millisecond)

                    s_stop_record_system_time = New DateTime(s_stop_record_system_time.Year, s_stop_record_system_time.Month, s_stop_record_system_time.Day, s_stop_record_system_time.Hour, s_stop_record_system_time.Minute, s_stop_record_system_time.Second, s_stop_record_system_time.Millisecond)

                    Dim n_start_record_system_time As ULONGLONG64 = s_start_record_system_time.ToFileTime()

                    Dim n_stop_record_system_time As ULONGLONG64 = s_stop_record_system_time.ToFileTime()

                    Dim po_record As ULONGLONG64 = 0

                    Dim pe_record As ULONGLONG64 = 0

                    If (n_start_record_system_time < n_start_search_system_times) Then

                        po_record = 0

                    Else

                        po_record = ((n_start_record_system_time - n_start_search_system_times) * Me.ClientRectangle.Width) / (n_stop_search_system_times - n_start_search_system_times)

                    End If

                    If (n_stop_record_system_time < n_start_search_system_times) Then

                        pe_record = 0

                    Else

                        pe_record = ((n_stop_record_system_time - n_start_search_system_times) * Me.ClientRectangle.Width) / (n_stop_search_system_times - n_start_search_system_times) + (1)

                    End If

                    Dim yo As ULONG32 = i * ((Me.ClientRectangle.Height - 2) / 4)

                    Dim ye As ULONG32 = (Me.ClientRectangle.Height - 2) / 4

                    e.Graphics.FillRectangle(Brushes.Blue, New Rectangle(po_record, yo, pe_record - po_record, ye))

                Next

            End If

        Next

        ' DRAW BOTTOM LINE (BLACK)
        '
        e.Graphics.DrawLine(Pens.Black, 0, Me.ClientRectangle.Bottom - 2, Me.ClientRectangle.Right, Me.ClientRectangle.Bottom - 2)

    End Sub

    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)

        If m.Msg = &H14 Then '&H00000014 = WM_ERASEBKGND

            Return

        End If

        'Debug.Print(m.ToString())

        MyBase.WndProc(m)

    End Sub

    Private Sub Timer_PAINT_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer_PAINT.Tick

        Me.Invalidate()

    End Sub

End Class
